/*
Copyright (C) BABEC. All rights reserved.

SPDX-License-Identifier: Apache-2.0
*/

package main

import (
	"errors"
	"fmt"
	"os"
	"runtime/debug"
	"strings"
	"time"

	"chainmaker.org/chainmaker-go/module/txfilter"
	"chainmaker.org/chainmaker-go/module/txfilter/filtercommon"
	bn "chainmaker.org/chainmaker/common/v2/birdsnest"
	sbn "chainmaker.org/chainmaker/common/v2/shardingbirdsnest"
	commonpb "chainmaker.org/chainmaker/pb-go/v2/common"
	"chainmaker.org/chainmaker/protocol/v2"
	"chainmaker.org/chainmaker/protocol/v2/mock"
	"chainmaker.org/chainmaker/protocol/v2/test"
	"chainmaker.org/chainmaker/utils/v2"
	"github.com/go-echarts/go-echarts/v2/charts"
	"github.com/go-echarts/go-echarts/v2/opts"
	"github.com/golang/mock/gomock"
)

const (
	path                     = "./data"
	heights           uint64 = 10000
	txNumberPerHeight        = 10000
)

var (
	FP         = errors.New("false positive")
	TXNumbers  = []int{127, 2892, 26, 3252, 5000, 127, 767, 127, 82, 4791, 4900, 245, 1, 3100, 27, 119, 4004, 881, 115, 2211, 119, 18, 4760, 242, 2909, 3071, 1930, 118, 6200, 3681, 3290, 119, 300, 4580, 31, 6, 4278, 4706, 263, 31, 226, 1276, 3415, 4918, 104, 376, 4112, 2288, 2112, 888, 1400, 2090, 300, 326, 862, 6800, 712, 334, 3712, 1288, 2881, 207, 1288, 1464, 84, 22, 619, 4313, 687, 4274, 20, 100, 4174, 740, 20, 1762, 2699, 1, 4274, 622, 1, 3850, 623, 1, 273, 3685, 1, 1019, 799, 1, 181, 6988, 644, 4273, 1, 100, 1361, 650, 1, 1123, 3433, 43, 1, 8559, 1041, 1123, 2788, 11, 1, 4351, 648, 241, 6624, 1975, 1, 4799, 241, 4753, 200, 40, 4760, 579, 1554, 7627, 3243, 1145, 40, 266, 1000, 3839, 1894, 240, 405, 1334, 966, 2083, 3306, 1694, 240, 4659, 240, 4759, 192, 374, 4434, 4000, 334, 565, 4284, 533, 312, 2634, 483, 83, 2116, 2801, 1630, 4996, 487, 4276, 304, 265, 1, 200, 4616, 184, 4816, 84, 133, 4000, 4998, 2, 1300, 3498, 2, 4559, 2, 14, 4298, 2, 149, 1200, 2899, 1, 4800, 1000, 3998, 400, 900, 8698, 2740, 2260, 49, 1140, 1959, 1, 300, 1400, 3100, 202, 21, 2177, 500, 2139, 82, 5000, 3077, 1923, 900, 1477, 2502, 4916, 84, 2177, 500, 100, 2920, 84, 300, 2435, 5084, 2700, 2279, 4500, 10000, 5493, 22, 100, 702, 5079, 278, 3213, 19, 2, 5000, 3461, 1133, 5006, 3079, 19, 2, 4900, 4979, 21, 1567, 3049, 5019, 3085, 15, 57, 8000, 70, 2523, 19, 2, 1930, 2370, 1855, 2512, 4, 357, 4624, 558, 1374, 18, 2764, 1353, 583, 2864, 308, 1627, 5000, 3064, 1935, 300, 1200, 8499, 2012, 2388, 1884, 2400, 537, 1936, 2764, 1398, 538, 703, 2343, 1398, 300, 4162, 538, 1100, 3062, 538, 600, 3700, 631, 1100, 3300, 546, 1100, 3300, 546, 1400, 3000, 546, 1400, 2900, 546, 1300, 3100, 546, 4946, 5000, 54, 1945, 1, 36, 600, 183, 4887, 54, 670, 10, 5800, 2776, 724, 1876, 34, 1980, 724, 1000, 3276, 4957, 724, 3731, 40, 384, 4611, 1917, 4345, 2814, 4360, 640, 504, 2715, 31, 693, 2913, 724, 964, 1770, 1046, 724, 1307, 1000, 1816, 5103, 2051, 2844, 1000, 1151, 2816, 3399, 1199, 402, 775, 514, 1553, 1260, 1000, 3324, 603, 441, 1110, 1214, 1550, 1050, 85, 2541, 233, 4400, 2157, 2816, 346, 201, 910, 2768, 1647, 585, 1034, 1534, 2157, 1100, 120, 2594, 1535, 1100, 134, 300, 3227, 6141, 208, 4460, 332, 31, 100, 4438, 5000, 208, 27, 9100, 4792, 331, 7981, 219, 1062, 5000, 209, 725, 6300, 299, 1948, 208, 700, 2509, 5207, 2501, 2291, 7, 101, 4691, 300, 4493, 207, 1100, 3200, 300, 700, 2100, 1793, 5000, 100, 1794, 208, 100, 3201, 1, 100, 935, 5000, 4988, 12, 4700, 989, 4010, 5400, 4500, 989, 1221, 2589, 1, 100, 1000, 2911, 4900, 1489, 3511, 689, 300, 3711, 996, 400, 1099, 8390, 3511, 4004, 100, 887, 753, 6013, 1887, 2969, 100, 887, 3017, 1312, 1, 61, 8726, 1888, 3088, 100, 887, 3666, 988, 3000, 1011, 3987, 1006, 7, 2200, 2217, 96, 5600, 4004, 96, 5400, 4004, 396, 951, 3140, 9, 700, 1587, 2499, 4, 3, 2551, 9, 3, 4984, 10, 3100, 1893, 1, 300, 4687, 5202, 4797, 3, 4793, 7, 26, 4398, 2, 280, 8090, 1910, 1778, 202, 401, 2803, 4998, 602, 1779, 1219, 2, 601, 921, 3279, 1779, 2, 300, 2079, 1524, 997, 5000, 2531, 100, 1485, 5000, 2621, 1603, 300, 2321, 3074, 400, 1400, 579, 4112, 98, 2611, 1300, 879, 2343, 2, 1600, 779, 1649, 669, 2382, 3, 100, 1965, 5000, 2100, 521, 210, 2346, 2418, 222, 7, 316, 2617, 1, 232, 1660, 200, 29, 1500, 2650, 18, 4, 300, 2182, 5007, 4900, 100, 900, 3300, 497, 100, 4800, 98, 300, 1037, 3656, 3, 100, 4459, 5001, 2, 3072, 1, 3, 92, 8697, 4995, 8, 7200, 2697, 523, 1392, 5, 3, 794, 1900, 3092, 3, 100, 518, 5006, 7, 4989, 3, 48, 267, 1300, 3077, 8, 3837, 318, 31, 2034, 2648, 318, 200, 1600, 2850, 32, 200, 2192, 5, 300, 18, 869, 4530, 152, 28, 100, 926, 451, 3, 327, 5538, 4115, 383, 1454, 100, 2261, 29, 2307, 2364, 9679, 2639, 2681, 4679, 321, 1312, 2682, 2261, 57, 2293, 1, 60, 300, 6957, 2682, 2300, 381, 1, 2937, 403, 60, 1769, 7869, 2131, 2066, 69, 371, 365, 366, 1506, 2866, 2060, 70, 2270, 2130, 51, 1865, 2135, 51, 9058, 4930, 1312, 1400, 2087, 71, 3829, 871, 15, 3800, 100, 12, 2329, 2453, 15, 2502, 1681, 17, 3500, 80, 56, 3507, 693, 156, 3379, 301, 88, 820, 500, 2287, 300, 1200, 2008, 100, 1400, 20, 1355, 1725, 1520, 1400, 1980, 232, 20, 258, 1954, 93, 843, 4157, 700, 200, 3702, 100, 1000, 3900, 1600, 2900, 30, 70, 300, 599, 1630, 300, 3686, 200, 1299, 3501, 1600, 3300, 97, 2800, 300, 2894, 100, 1500, 3400, 2000, 2971, 167, 2600, 200, 2680, 300, 2100, 2600, 2700, 2100, 35, 4510, 3890, 257, 1136, 200, 1430, 1, 5000, 4998, 100, 4900, 4905, 200, 4800, 4998, 193, 1100, 3260, 300, 1700, 2998, 200, 1100, 3421, 5000, 4998, 2, 1900, 2898, 2, 4799, 1, 578, 2041, 753, 2, 1500, 3198, 2, 1100, 2300, 1498, 100, 1400, 3498, 200, 4800, 117, 2641, 758, 1, 1500, 2441, 759, 4700, 3300, 941, 200, 2500, 1541, 100, 800, 3341, 100, 700, 3437, 4996, 763, 95, 7798, 763, 2239, 763, 195, 719, 1983, 259, 708, 2542, 762, 95, 700, 96, 118, 900, 796, 3304, 1300, 96, 67, 2700, 4, 708, 1600, 96, 2637, 100, 800, 10000, 4286, 2296, 2704, 1144, 2856, 98, 385, 6701, 1605, 1095, 2305, 5, 797, 1600, 1706, 800, 794, 3206, 1500, 494, 2091, 100, 800, 794, 1506, 6400, 2364, 200, 1400, 94, 200, 2906, 254, 1584, 668, 1748, 1458, 100, 852, 294, 4800, 3305, 794, 100, 1648, 4700, 1558, 1693, 1748, 1500, 3500, 656, 100, 1648, 3251, 1, 4998, 1504, 400, 3096, 4099, 1401, 2096, 100, 700, 3014, 90, 4910, 921, 1500, 2378, 1, 821, 4078, 1, 100, 3979, 921, 1200, 2779, 94, 9079, 2221, 2779, 21, 100, 422, 1227, 5921, 1425, 54, 2773, 2227, 800, 278, 6095, 921, 1300, 415, 727, 921, 139, 952, 4895, 2732, 100, 480, 749, 2537, 858, 63, 3940, 5900, 160, 900, 3700, 200, 1100, 3561, 139, 1000, 3200, 700, 1000, 3761, 139, 900, 3661, 139, 917, 7343, 1473, 2028, 139, 4861, 674, 4185, 141, 330, 4331, 139, 500, 3589, 711, 300, 2300, 1489, 1989, 711, 2366, 711, 200, 3544, 11, 300, 2315, 672, 200, 2944, 200, 1000, 3089, 300, 1200, 2789, 100, 1500, 8400, 1600, 400, 2261, 511, 200, 4800, 2900, 1888, 12, 1100, 2983, 717, 1100, 813, 2887, 1200, 1513, 1682, 200, 1100, 2986, 300, 1613, 2543, 200, 1100, 2272, 305, 254, 3376, 184, 1016, 3287, 100, 1400, 2980, 5000, 1800, 3200, 1600, 2792, 508, 1000, 3184, 716, 3400, 1184, 16, 717, 100, 3125, 716, 100, 1858, 5716, 1800, 2484, 100, 1400, 2782, 649, 3551, 800, 1200, 2682, 718, 1200, 2882, 718, 9900, 4281, 1790, 800, 300, 1415, 719, 471, 3809, 4200, 800, 283, 2300, 1281, 19, 300, 2300, 1681, 1, 4199, 801, 1300, 2399, 1201, 6100, 3793, 7, 5200, 4081, 619, 2510, 28, 1489, 583, 610, 8, 2110, 713, 6, 3072, 3798, 1201, 97, 300, 8401, 198, 842, 3353, 1, 97, 10000, 6036, 3867, 1282, 13, 965, 3526, 5009, 3110, 1877, 197, 234, 3960, 13, 100, 1834, 5012, 1011, 2966, 2081, 406, 613, 3777, 210, 813, 600, 2677, 513, 1211, 2184, 1594, 68, 600, 894, 1593, 213, 243, 2700, 410, 2425, 294, 12, 197, 1018, 1989, 1989, 5816, 4178, 520, 8, 2081, 2584, 2822, 2178, 420, 100, 700, 2798, 202, 2397, 2401, 100, 1000, 1397, 481, 420, 2, 3097, 1901, 2, 1400, 997, 3537, 1554, 47, 2636, 9727, 322, 4042, 2, 100, 1396, 1499, 1, 149, 9047, 4751, 1604, 2, 100, 3368, 1420, 600, 2980, 100, 700, 618, 3181, 4218, 782, 700, 618, 3580, 481, 937, 3580, 1136, 2600, 980, 1, 87, 943, 1, 3582, 1418, 4400, 3280, 1419, 300, 600, 7679, 4, 4999, 3581, 4, 200, 3380, 200, 1214, 1436, 1581, 1415, 1, 900, 1086, 2910, 1890, 1494, 1416, 1590, 1494, 1416, 1700, 290, 4750, 8, 4702, 290, 1690, 500, 2410, 1600, 40, 3160, 5000, 3160, 1840, 1107, 1660, 1840, 2316, 960, 1440, 7960, 1840, 2223, 1710, 100, 2333, 5000, 1840, 117, 860, 1100, 740, 1840, 200, 2957, 1340, 100, 2119, 701, 1140, 3913, 100, 2500, 2400, 1350, 3550, 301, 3100, 200, 4800, 2600, 2100, 106, 1900, 1900, 5000, 4900, 200, 4800, 2900, 1900, 293, 2600, 100, 2811, 70, 700, 3541, 200, 1800, 3000, 2786, 2114, 176, 3300, 100, 4999, 258, 1042, 3700, 2000, 2799, 1, 1110, 3600, 99, 3946, 1054, 4999, 100, 1100, 3794, 1, 200, 1107, 2, 300, 1093, 2, 100, 1141, 99, 1, 4993, 300, 900, 3790, 1, 200, 1041, 99, 1, 166, 2200, 1200, 3790, 1, 500, 6015, 1, 2900, 2098, 4999, 1, 987, 5002, 4998, 2, 3200, 998, 2, 200, 1100, 3998, 1232, 200, 726, 3768, 200, 1032, 728, 140, 4337, 2940, 1232, 828, 1641, 1099, 2060, 2400, 240, 1232, 628, 100, 2643, 32, 800, 745, 1572, 3428, 1472, 728, 2543, 1429, 528, 2743, 1429, 600, 528, 2243, 34, 400, 428, 14, 3858, 5000, 315, 3, 72, 2175, 917, 3258, 457, 315, 167, 4200, 1141, 3859, 320, 1, 4675, 1, 162, 2524, 341, 1, 38, 1700, 2899, 1, 4699, 39, 3041, 788, 1, 3079, 1920, 1, 220, 1979, 1920, 1, 4899, 1, 167, 1, 1200, 1879, 1740, 3260, 1, 2979, 1720, 1, 1000, 3300, 599, 500, 1800, 2699, 100, 854, 3196, 1, 8, 870, 1925, 1, 4999, 200, 700, 2174, 100, 3000, 1333, 826, 656, 1006, 1000, 925, 1, 3073, 1926, 1, 3074, 1925, 1, 2272, 3928, 2988, 5000, 2600, 2400, 1800, 1526, 1503, 300, 1900, 1756, 5261, 3072, 1067, 100, 2972, 1178, 100, 1100, 3800, 2880, 720, 129, 980, 711, 2009, 1980, 2200, 520, 1100, 1380, 2420, 1533, 647, 2720, 1900, 80, 103, 7200, 2800, 1911, 80, 2640, 504, 2, 200, 2520, 2100, 79, 1, 2320, 2278, 2, 700, 2020, 2180, 1398, 3500, 2, 4910, 90, 1318, 2, 90, 2630, 2, 200, 874, 2, 200, 649, 2951, 100, 748, 2, 200, 648, 2500, 852, 87, 9213, 4207, 793, 748, 2000, 1450, 100, 748, 1266, 2252, 300, 548, 3900, 3659, 193, 448, 1400, 2750, 940, 3260, 800, 700, 1794, 10000, 4540, 460, 4409, 100, 1000, 3900, 1900, 3000, 296, 2900, 200, 2019, 200, 1900, 2900, 1800, 3000, 138, 3300, 1000, 213, 3600, 100, 1651, 200, 1800, 3000, 1700, 2999, 1, 4700, 100, 8, 3400, 1500, 2, 4298, 2, 62, 3100, 763, 5037, 3700, 600, 5000, 2874, 1989, 37, 2100, 2563, 137, 900, 3462, 538, 3422, 1000, 111, 3100, 575, 37, 4900, 4447, 553, 1268, 3147, 553, 1200, 3146, 553, 400, 3600, 998, 1, 200, 5233, 45, 200, 4247, 500, 900, 410, 1401, 57, 1969, 100, 900, 457, 3543, 1452, 5, 4600, 2773, 2122, 400, 1400, 1743, 3543, 1457, 223, 5000, 1457, 72, 3695, 105, 1562, 8144, 2969, 2031, 600, 1869, 2326, 300, 800, 1848, 2225, 2475, 957, 900, 1832, 2168, 1100, 1641, 189, 4109, 891, 2604, 100, 1500, 1232, 300, 1715, 88, 1792, 1560, 1639, 100, 1000, 3522, 176, 1534, 1939, 862, 104, 4900, 3057, 302, 76, 851, 3605, 377, 65, 2600, 6856, 65, 100, 4728, 4458, 477, 3260, 115, 59, 4826, 100, 400, 4461, 2538, 2413, 49, 4900, 1299, 3701, 199, 2247, 5153, 2347, 2454, 167, 6, 102, 2335, 2542, 2458, 195, 202, 2235, 2366, 97, 2, 2435, 5000, 189, 1657, 4251, 3602, 168, 168, 28, 1651, 7690, 1868, 932, 73, 167, 22, 1777, 3150, 240, 344, 850, 1495, 167, 23, 1187, 7713, 3419, 2359, 1108, 777, 781, 3410, 1486, 102, 76, 3334, 5648, 101, 2077, 2019, 4120, 879, 2, 206, 2534, 2134, 1049, 3472, 173, 6, 300, 5864, 102, 205, 4670, 2505, 2190, 1041, 1400, 2458, 306, 100, 2000, 1859, 736, 200, 4799, 2300, 1964, 736, 2664, 2135, 1, 1373, 1403, 7023, 2146, 1413, 741, 3956, 1043, 1667, 608, 435, 1, 1683, 1, 146, 9023, 4263, 1130, 2095, 737, 1, 766, 1, 966, 3596, 37, 4263, 301, 664, 2, 4035, 965, 2918, 100, 849, 18, 3835, 904, 61, 100, 3933, 965, 178, 200, 3708, 278, 3027, 1677, 1, 2, 9005, 800, 2927, 988, 5580, 4419, 4008, 93, 280, 237, 2719, 281, 903, 27, 81, 5911, 2327, 992, 281, 8698, 3002, 2904, 100, 100, 9686, 1802, 3127, 976, 95, 3728, 237, 177, 1070, 2481, 4029, 1272, 3726, 71, 800, 5099, 777, 2951, 970, 47, 174, 3553, 879, 91, 4030, 1358, 2672, 970, 2, 4698, 302, 3513, 970, 302, 6744, 3219, 81, 3300, 5069, 589, 875, 3519, 523, 81, 200, 8265, 3262, 6738, 5664, 5380, 4701, 8270, 8112, 8261, 6966, 8919, 9961, 10000, 10000, 10000, 10000, 10000, 10000, 10000, 10000, 10000, 10000, 10000, 10000, 10000, 10000, 10000, 10000, 10000, 10000, 10000, 10000, 10000, 10000, 10000, 10000, 10000, 10000, 10000, 10000, 10000, 10000, 10000, 10000, 10000, 10000, 10000, 10000, 10000, 10000, 10000, 10000, 10000, 10000, 10000, 10000, 10000, 10000, 10000, 10000, 10000, 10000, 10000, 10000, 10000, 10000, 10000, 10000, 10000, 10000, 10000, 10000, 10000, 10000, 10000, 10000, 10000, 10000, 10000, 10000, 10000, 10000, 10000, 10000, 10000, 10000, 10000, 10000, 10000, 10000, 10000, 10000, 10000, 10000, 10000, 10000, 10000, 10000, 10000, 10000, 10000, 10000, 10000, 10000, 10000, 10000, 10000, 10000, 10000, 10000, 10000, 10000, 10000, 10000, 10000, 10000, 10000, 10000, 10000, 10000, 10000, 10000, 10000, 10000, 10000, 10000, 10000, 10000, 10000, 10000, 10000, 10000, 10000, 10000, 10000, 10000, 10000, 10000, 10000, 10000, 10000, 10000, 10000, 10000, 10000, 10000, 10000, 10000, 10000, 10000, 10000, 10000, 10000, 10000, 10000, 10000, 10000, 10000, 10000, 10000, 10000, 10000, 10000, 10000, 10000, 10000, 10000, 10000, 10000, 10000, 10000, 10000, 10000, 10000, 10000, 10000, 10000, 10000, 10000, 10000, 10000, 10000, 10000, 10000, 10000, 10000, 10000, 10000, 10000, 10000, 10000, 10000, 10000, 10000, 10000, 10000, 10000, 10000, 10000, 10000, 10000, 10000, 10000, 10000, 10000, 10000, 10000, 10000, 10000, 10000, 10000, 10000, 10000, 10000, 10000, 10000, 10000, 10000, 10000, 10000, 10000, 10000, 10000, 10000, 10000, 10000, 10000, 10000, 10000, 10000, 10000, 10000, 10000, 10000, 10000, 10000, 10000, 10000, 10000, 10000, 10000, 10000, 10000, 10000, 10000, 10000, 10000, 10000, 10000, 10000, 10000, 10000, 10000, 10000, 10000, 10000, 10000, 10000, 10000, 10000, 10000, 10000, 10000, 10000, 10000, 10000, 10000, 10000, 10000, 10000, 10000, 10000, 10000, 10000, 10000, 10000, 10000, 10000, 10000, 10000, 10000, 10000, 10000, 10000, 10000, 10000, 10000, 10000, 10000, 10000, 10000, 10000, 10000, 10000, 10000, 10000, 10000, 10000, 10000, 10000, 10000, 10000, 10000, 10000, 10000, 10000, 10000, 10000, 10000, 10000, 10000, 10000, 10000, 10000, 10000, 10000, 10000, 10000, 10000, 10000, 10000, 10000, 10000, 10000, 10000, 10000, 10000, 10000, 10000, 10000, 10000, 10000, 10000, 10000, 10000, 10000, 10000, 10000, 10000, 10000, 10000, 10000, 10000, 10000, 10000, 10000, 10000, 10000, 10000, 10000, 10000, 10000, 10000, 10000, 10000, 10000, 10000, 10000, 10000, 10000, 10000, 10000, 10000, 10000, 10000, 10000, 10000, 10000, 10000, 10000, 10000, 10000, 10000, 10000, 10000, 10000, 10000, 10000, 10000, 10000, 10000, 10000, 10000, 10000, 10000, 10000, 10000, 10000, 10000, 10000, 10000, 10000, 10000, 10000, 10000, 10000, 10000, 10000, 10000, 10000, 10000, 10000, 9919, 9755, 10000, 10000, 9156, 10000, 10000, 10000, 8990, 8868, 8331, 7975, 8028, 7672, 8974, 6553, 5611, 3900, 3746, 2562, 2415, 10000, 5512, 2598, 2392, 274, 400, 4600, 1942, 898, 474, 4700, 1653, 2873, 1653, 1972, 901, 126, 1527, 1975, 444, 74, 5000, 1997, 1074, 303, 3374, 3126, 1400, 200, 975, 6290, 1223, 1203, 2100, 100, 4900, 4067, 1172, 2400, 954, 5476, 3588, 936, 9700, 4224, 1350, 493, 933, 272, 9026, 4574, 1398, 500, 2850, 1172, 2, 3950, 1048, 300, 3350, 1172, 2, 100, 1947, 5075, 973, 2, 4722, 78, 169, 2798, 2, 10, 7911, 3623, 1379, 1900, 2898, 2, 5197, 4503, 4998, 1700, 4498, 2, 3789, 2, 183, 5060, 2, 3616, 2, 1582, 3416, 1, 381, 4617, 6560, 3440, 2426, 381, 615, 3253, 6797, 3204, 1329, 2, 382, 314, 1004, 300, 143, 200, 4102, 5361, 1333, 2971, 5359, 4538, 4422, 4639, 337, 300, 5247, 696, 4302, 698, 4900, 2424, 1880, 200, 300, 821, 1276, 3124, 1376, 600, 1753, 6878, 2353, 2179, 397, 4909, 2444, 2237, 71, 2353, 1877, 4301, 769, 209, 5699, 2371, 2699, 1500, 1886, 343, 4691, 312, 4581, 70, 1252, 3337, 3, 100, 1151, 7105, 4929, 71, 1251, 4900, 3745, 1485, 3400, 115, 5400, 4300, 104, 3450, 3, 198, 3496, 5000, 4, 1600, 3300, 1796, 4, 300, 1496, 2015, 4, 172, 896, 1985, 1219, 100, 1696, 3200, 100, 1600, 96, 100, 1600, 1319, 3300, 1781, 115, 618, 57, 3143, 735, 1700, 3300, 7749, 2536, 2464, 2000, 1637, 674, 215, 3817, 968, 1600, 536, 1087, 995, 2236, 1794, 8204, 1796, 4291, 100, 400, 2704, 1424, 1591, 3407, 5000, 1600, 923, 1200, 1126, 2672, 1, 1675, 38, 4976, 24, 272, 3324, 1637, 3362, 2493, 2507, 1668, 400, 417, 2507, 1719, 1543, 1738, 17, 1943, 1990, 101, 953, 1785, 5819, 3507, 1493, 1600, 590, 1737, 1973, 419, 4295, 400, 1543, 848, 20, 5965, 4034, 1900, 55, 5530, 2307, 200, 2291, 261, 2247, 2493, 200, 1600, 1347, 1, 200, 148, 3557, 1792, 2159, 292, 201, 148, 2851, 349, 459, 2841, 2159, 2492, 48, 100, 4551, 1959, 1400, 1383, 4651, 349, 2157, 1567, 349, 2159, 30, 4868, 5000, 2711, 900, 1257, 6, 4862, 132, 7100, 2294, 2147, 57, 132, 6, 4464, 136, 4862, 6, 200, 1422, 7, 200, 4664, 200, 1400, 210, 755, 6, 215, 139, 200, 4800, 1600, 39, 1830, 200, 1400, 39, 3261, 1000, 638, 300, 1400, 1661, 651, 5001, 3361, 1, 100, 2209, 1600, 39, 82, 2238, 1639, 155, 2061, 100, 1538, 100, 4899, 190, 2639, 1, 183, 1657, 500, 1370, 200, 2657, 2142, 100, 400, 2357, 1550, 89, 8, 2727, 239, 102, 3357, 1643, 260, 800, 3621, 181, 939, 100, 479, 1478, 1904, 238, 100, 3261, 1638, 200, 500, 4103, 100, 1300, 3600, 196, 4, 31, 5274, 4122, 4, 3500, 3860, 2536, 2460, 20, 2395, 5746, 2815, 1439, 2300, 2536, 118, 3905, 1095, 47, 1564, 5000, 2536, 2300, 959, 840, 3360, 1640, 47, 1700, 2634, 2464, 2400, 65, 5046, 2536, 43, 2421, 4400, 2536, 1564, 700, 800, 1262, 2464, 806, 1730, 5000, 2705, 731, 5888, 3436, 773, 3233, 1474, 90, 80, 300, 7756, 3380, 825, 1169, 838, 380, 3056, 1184, 1377, 2034, 6, 378, 2588, 91, 300, 80, 900, 3412, 8, 2776, 1838, 6, 385, 1, 1597, 5385, 4265, 734, 1, 1600, 3005, 4613, 386, 1936, 5736, 4567, 433, 100, 1400, 3109, 1921, 3078, 379, 1536, 879, 2200, 1639, 2979, 384, 36, 4579, 385, 1436, 2601, 838, 1, 5000, 3747, 24, 1, 2658, 1458, 3482, 84, 200, 533, 3881, 6612, 3410, 736, 3286, 26, 1, 4700, 4914, 85, 60, 3240, 6675, 4911, 88, 1, 7172, 4974, 5024, 20, 3004, 1976, 3533, 1467, 4, 4777, 23, 5, 1700, 3200, 3, 5775, 3622, 285, 479, 21, 285, 1678, 22, 224, 9079, 4252, 769, 700, 3331, 769, 2497, 2281, 22, 2377, 22, 176, 2500, 2264, 1109, 22, 200, 3422, 1700, 453, 7061, 1450, 53, 2311, 4714, 2150, 2349, 200, 765, 1666, 816, 2307, 1855, 300, 2000, 7139, 787, 1840, 27, 7640, 3145, 1855, 1247, 200, 585, 2305, 384, 2346, 1801, 146, 3768, 700, 186, 1231, 7352, 2631, 2369, 1, 445, 1417, 1100, 1938, 1862, 8038, 4214, 786, 83, 3000, 6216, 737, 3491, 1, 100, 1100, 3016, 500, 506, 8208, 3432, 785, 762, 1, 100, 8331, 846, 3385, 769, 9216, 2684, 2316, 11, 12, 7112, 34, 1100, 3116, 22, 12, 4964, 3431, 1485, 60, 5000, 3400, 1577, 7, 4, 5011, 1435, 22, 1477, 1534, 12, 3151, 1000, 546, 3326, 1544, 2, 2237, 1526, 20, 3791, 1911, 3088, 12, 500, 2800, 1588, 300, 700, 7454, 1200, 2254, 1535, 100, 500, 7854, 100, 654, 4239, 600, 900, 3487, 76, 500, 7878, 578, 3676, 746, 700, 2400, 1598, 459, 2994, 1535, 2453, 1, 1534, 1, 600, 6582, 3465, 1535, 12, 4700, 3453, 1535, 477, 2976, 6535, 4388, 612, 43, 2000, 1924, 5764, 1024, 3200, 764, 1576, 3324, 1664, 1, 400, 4599, 100, 1400, 3496, 100, 200, 4700, 2570, 630, 420, 704, 600, 30, 200, 1921, 2779, 21, 200, 1949, 7221, 2149, 916, 100, 2049, 2851, 1949, 630, 1963, 5800, 3479, 721, 1649, 2851, 190, 463, 4002, 165, 100, 1754, 4760, 100, 700, 2346, 3340, 1660, 240, 1077, 3583, 240, 100, 1300, 2183, 5000, 7, 4240, 100, 901, 38, 3109, 7, 1001, 400, 3492, 1008, 300, 1900, 1692, 700, 222, 121, 3827, 686, 322, 166, 2898, 929, 5173, 4013, 987, 4128, 1661, 2331, 22, 100, 65, 8523, 1091, 3827, 165, 200, 1928, 827, 65, 3763, 10, 164, 1, 1200, 700, 2832, 1, 300, 3561, 1, 197, 2636, 168, 1, 13, 9371, 3907, 1093, 600, 688, 8711, 175, 217, 4608, 2989, 2011, 789, 5725, 3478, 788, 3177, 765, 4235, 5000, 788, 1528, 101, 688, 32, 2200, 7672, 128, 1912, 99, 55, 4845, 4384, 616, 500, 1400, 2788, 1058, 3782, 160, 5055, 4817, 128, 5009, 4817, 128, 500, 4017, 83, 4071, 125, 3, 9617, 1955, 3045, 458, 4414, 128, 28, 100, 2149, 5028, 2900, 2097, 50, 800, 3125, 28, 406, 2560, 3, 100, 1071, 3, 300, 4700, 200, 300, 1929, 127, 3, 293, 3901, 1097, 2, 4997, 1503, 3497, 1, 383, 4614, 414, 1100, 3483, 4997, 417, 4583, 400, 14, 5003, 417, 200, 4383, 100, 1700, 2783, 417, 1800, 2783, 414, 200, 3317, 5003, 4914, 86, 200, 14, 212, 460, 939, 3644, 214, 200, 101, 1061, 4583, 414, 9586, 4997, 411, 1200, 3000, 46, 176, 4824, 4997, 4997, 3, 581, 5001, 3, 4997, 4997, 3, 192, 3897, 3, 295, 100, 1664, 2107, 7753, 1920, 3074, 3, 68, 1046, 2274, 1655, 3, 447, 200, 926, 1500, 2273, 1127, 7000, 1674, 1126, 1697, 3, 149, 2719, 1081, 198, 2253, 1646, 1, 4899, 1, 3353, 1, 100, 1026, 1647, 800, 2553, 1, 200, 3153, 1301, 3697, 3, 4900, 4994, 6, 4993, 2475, 2524, 100, 300, 275, 1401, 100, 1595, 2, 100, 575, 675, 4323, 97, 75, 4324, 1, 1800, 2124, 1, 575, 100, 1388, 4976, 125, 594, 2424, 1, 12, 2232, 1824, 117, 76, 100, 4224, 2300, 2008, 16, 927, 1697, 34, 242, 1700, 2624, 876, 2133, 1991, 5575, 4325, 675, 200, 2133, 6991, 4099, 4309, 129, 42, 1400, 2883, 75, 2609, 1716, 5574, 2910, 1416, 200, 1800, 922, 1300, 104, 574, 2878, 3122, 778, 1404, 612, 62, 2692, 1634, 674, 1600, 590, 1833, 2014, 64, 2490, 5063, 1310, 1613, 647, 1, 2922, 214, 2709, 2078, 509, 1613, 1010, 563, 1, 4999, 2078, 1310, 1613, 677, 1, 1082, 3627, 1373, 199, 3387, 1613, 2077, 1000, 10, 1613, 490, 1410, 3418, 10, 3690, 1310, 2100, 26, 1574, 1900, 2896, 4, 1200, 2100, 18, 3118, 8, 1571, 5650, 2776, 1574, 1500, 992, 2405, 106, 3319, 1574, 5001, 3426, 1574, 1200, 1759, 1574, 18, 162, 3151, 1574, 1683, 37, 3205, 5074, 1685, 1706, 900, 674, 3257, 1749, 1574, 12, 7641, 2359, 220, 1280, 74, 300, 1127, 6600, 3020, 1507, 137, 100, 1100, 2062, 399, 1200, 121, 900, 2279, 400, 1000, 85, 3280, 6286, 3335, 1665, 1, 100, 1108, 356, 934, 367, 1995, 56, 322, 100, 1, 3343, 1320, 1, 2932, 1266, 35, 27, 1100, 3814, 28, 2119, 1200, 1, 4973, 1680, 2145, 1, 6600, 3399, 2145, 1174, 1, 800, 782, 3316, 200, 1400, 80, 3319, 1, 1680, 2674, 3, 1715, 3, 200, 4797, 100, 800, 4097, 3449, 1551, 72, 4000, 51, 911, 164, 4834, 1413, 5000, 1549, 811, 140, 803, 44, 5000, 10000, 5901, 2745, 1709, 547, 947, 1413, 2640, 47, 900, 601, 2640, 945, 610, 88, 4912, 3540, 1413, 87, 1714, 2347, 1199, 1454, 1400, 414, 2144, 246, 400, 1208, 2358, 2588, 2413, 2054, 946, 1413, 2554, 546, 224, 788, 2554, 546, 1400, 99, 120, 246, 823, 1144, 546, 400, 1500, 1800, 600, 127, 351, 766, 7255, 100, 2038, 3709, 1517, 100, 2152, 1517, 100, 1184, 840, 2731, 17, 100, 1112, 3688, 300, 1800, 1588, 1112, 300, 2724, 300, 1212, 3488, 1500, 3400, 227, 1300, 300, 1382, 300, 1100, 2191, 100, 1500, 2735, 100, 1300, 3600, 2800, 824, 1076, 1400, 2200, 1100, 1054, 400, 2786, 1059, 315, 2871, 1057, 100, 4900, 1076, 100, 1197, 626, 1074, 78, 100, 3641, 5003, 1144, 200, 4800, 3741, 3, 1256, 800, 100, 2225, 100, 400, 2731, 3, 200, 1876, 2300, 200, 3541, 3, 600, 3163, 1400, 3597, 3, 4700, 4997, 3, 800, 27, 3873, 1300, 2573, 136, 27, 26, 3847, 1620, 2280, 1084, 23, 2471, 1381, 1000, 27, 3873, 1027, 400, 792, 3364, 1636, 1134, 12, 874, 3014, 15, 200, 2539, 15, 100, 4885, 100, 4885, 15, 2100, 2685, 15, 100, 7064, 2813, 3600, 114, 238, 1481, 2304, 15, 1100, 1249, 2547, 1252, 1597, 2151, 878, 1171, 2551, 1100, 1176, 73, 4900, 2551, 287, 1174, 75, 2551, 2851, 2149, 195, 1481, 1372, 377, 920, 3880, 202, 3100, 36, 2066, 387, 2513, 2100, 1600, 2999, 1, 4800, 2300, 2700, 4899, 1, 192, 2100, 2400, 181, 3100, 100, 80, 1800, 4900, 2900, 1800, 2700, 100, 300, 2312, 2188, 600, 2112, 234, 5088, 2800, 1630, 500, 2300, 12, 2188, 300, 1990, 540, 2217, 5257, 1829, 983, 2188, 2177, 2735, 88, 1000, 1412, 2188, 3346, 1654, 1360, 3, 200, 1454, 3346, 63, 1366, 3585, 1915, 1688, 1005, 607, 3342, 1654, 1651, 1694, 3254, 1745, 43, 1351, 1812, 1695, 3405, 1539, 1462, 700, 276, 5000, 1453, 1328, 4, 5019, 3253, 1028, 1593, 1712, 976, 19, 2, 1591, 6771, 4275, 725, 2522, 6, 2311, 974, 3, 616, 96, 4185, 719, 302, 3591, 5000, 500, 987, 2232, 328, 398, 5000, 726, 10, 577, 797, 3300, 974, 100, 400, 2803, 726, 200, 479, 1297, 3287, 987, 28, 595, 329, 3003, 1201, 594, 2821, 696, 96, 4302, 598, 587, 700, 2808, 894, 500, 2800, 974, 98, 100, 2098, 900, 698, 99, 595, 3179, 726, 500, 37, 3693, 99, 581, 4419, 100, 1600, 2120, 500, 81, 4419, 1981, 2620, 99, 99, 500, 81, 81, 2293, 2126, 5000, 4419, 581, 74, 4145, 581, 231, 2500, 5294, 3, 200, 73, 3946, 581, 227, 4727, 673, 3746, 200, 73, 1535, 3, 200, 4791, 237, 400, 2348, 3, 237, 1639, 63, 200, 37, 9463, 4991, 246, 2583, 3, 237, 237, 1300, 3454, 12, 4925, 63, 244, 9456, 300, 2054, 9, 222, 237, 100, 2285, 238, 2, 33, 900, 3700, 89, 35, 934, 3822, 236, 332, 3381, 209, 31, 5, 609, 7059, 2295, 1000, 3932, 2370, 9, 231, 1, 2364, 2604, 272, 159, 600, 3998, 215, 604, 3941, 5819, 4181, 819, 769, 3396, 819, 800, 100, 4100, 46, 305, 4695, 1585, 85, 3330, 3601, 699, 86, 900, 3114, 899, 99, 83, 4018, 5003, 783, 4192, 83, 100, 4794, 100, 700, 687, 786, 2564, 83, 4717, 83, 1404, 9395, 3513, 1487, 83, 1400, 4, 2852, 283, 1236, 200, 1604, 1122, 99, 36, 905, 6482, 636, 2882, 35, 1, 893, 1400, 36, 264, 8361, 1439, 2082, 36, 2980, 1984, 2, 1700, 1858, 33, 2309, 2656, 406, 3112, 1446, 3841, 1165, 1213, 813, 2344, 37, 3618, 1282, 413, 6805, 1395, 1805, 359, 36, 1805, 36, 65, 3366, 5002, 1841, 3157, 1341, 2300, 1359, 200, 1606, 1970, 2, 500, 1566, 2, 100, 1741, 1198, 2, 126, 2494, 1406, 76, 2200, 194, 1306, 1600, 1794, 1406, 1700, 1794, 768, 2, 3594, 1406, 1384, 1204, 2, 1100, 2394, 1404, 1802, 1794, 1403, 961, 503, 1, 1498, 3202, 1355, 5042, 2, 3595, 43, 2, 164, 4543, 457, 443, 1642, 402, 54, 100, 1542, 456, 1300, 1502, 1642, 356, 300, 2602, 200, 1894, 2001, 370, 1672, 56, 2042, 400, 1698, 800, 56, 4140, 1501, 475, 2098, 922, 1980, 999, 200, 660, 4140, 3, 17, 4122, 6277, 3780, 820, 882, 18, 184, 3123, 859, 1, 5000, 4123, 877, 1923, 859, 1, 20, 4100, 878, 18, 2300, 2008, 2, 1, 17, 857, 3, 15, 4675, 10, 15, 4376, 20, 4, 600, 1700, 2485, 100, 4900, 4975, 200, 600, 3713, 10000, 4994, 21, 368, 4482, 411, 3486, 3, 1, 5000, 4982, 18, 4493, 2, 14, 9482, 418, 4586, 3442, 1559, 1, 9782, 418, 4583, 100, 4000, 899, 100, 3200, 1698, 1, 200, 908, 3, 100, 1079, 1999, 1, 116, 7300, 2400, 2196, 3, 280, 1063, 3, 100, 538, 7603, 2400, 2641, 3, 100, 855, 3700, 3697, 3, 5181, 4097, 3, 976, 3321, 5003, 412, 4, 4951, 3, 476, 800, 5946, 3539, 3459, 800, 64, 411, 4147, 1266, 914, 854, 4146, 854, 1404, 839, 13, 3749, 851, 462, 8787, 1627, 3924, 617, 74, 3246, 473, 603, 3924, 160, 600, 5016, 2411, 2400, 58, 2524, 1076, 8, 2700, 624, 460, 100, 3824, 1076, 1400, 2424, 224, 500, 76, 205, 2788, 5000, 1320, 501, 576, 6, 2400, 5300, 1200, 1900, 1823, 1076, 100, 1200, 2623, 127, 4349, 873, 100, 1800, 2023, 200, 527, 194, 350, 727, 286, 3922, 1078, 239, 2022, 1078, 730, 624, 348, 728, 3921, 1052, 27, 4000, 996, 3, 836, 2368, 996, 400, 3560, 996, 1400, 2561, 996, 1000, 2881, 1077, 890, 4068, 41, 2882, 1077, 39, 1500, 333, 4700, 39, 1733, 2500, 39, 500, 1233, 2834, 294, 1772, 2185, 294, 623, 72, 1876, 1352, 3006, 294, 1772, 1034, 294, 90, 72, 369, 4631, 300, 1500, 1352, 1500, 148, 48, 1848, 1832, 1320, 1848, 2384, 768, 1300, 148, 2084, 600, 5616, 632, 2052, 1716, 32, 1652, 7616, 1671, 1216, 596, 36, 1816, 32, 452, 3145, 9926, 2580, 709, 330, 14, 2929, 32, 4367, 1039, 4461, 539, 633, 600, 439, 5000, 4824, 3404, 100, 5000, 939, 1273, 651, 2924, 5, 300, 735, 1300, 2432, 33, 5900, 2435, 1565, 800, 35, 324, 2465, 1035, 63, 10000, 3399, 1601, 35, 100, 1496, 1100, 501, 3399, 1, 3399, 1601, 2600, 1999, 101, 4800, 3999, 1001, 1900, 2892, 101, 900, 1254, 2746, 3354, 44, 2, 1400, 654, 2843, 2, 836, 2935, 2, 100, 1451, 2100, 844, 2, 9700, 4997, 2057, 44, 2, 82, 1641, 1304, 2, 8100, 1457, 485, 2151, 4, 1, 6074, 2910, 2090, 361, 82, 2464, 69, 445, 78, 7472, 1245, 3754, 44, 200, 4351, 44, 4954, 2, 44, 7100, 2456, 309, 33, 7886, 3270, 1397, 333, 1200, 7623, 777, 3680, 423, 377, 9188, 1677, 3323, 300, 33, 4222, 333, 500, 3721, 400, 33, 273, 33, 200, 4034, 300, 2200, 2167, 100, 1800, 7767, 6, 4994, 5000, 1000, 3987, 7, 3500, 93, 9, 1000, 3891, 3, 2991, 7, 1287, 6, 100, 2054, 5006, 4994, 6, 800, 3800, 300, 6, 200, 1870, 7, 200, 1860, 6, 4400, 600, 639, 4161, 100, 800, 3900, 100, 4400, 1300, 4092, 100, 500, 3862, 6, 100, 1671, 1200, 3781, 19, 600, 3200, 1094, 1, 100, 4892, 697, 1034, 3269, 600, 62, 1881, 4303, 600, 97, 400, 2600, 1203, 300, 97, 4303, 200, 500, 18, 600, 2885, 697, 418, 300, 3982, 100, 1800, 2580, 200, 1400, 3400, 2400, 2182, 18, 1300, 2882, 718, 1600, 2482, 718, 1382, 300, 418, 1500, 2582, 126, 18, 4282, 717, 200, 1300, 2782, 615, 3, 4282, 700, 3582, 715, 100, 600, 83, 3199, 5715, 985, 718, 200, 579, 200, 1900, 1399, 4282, 716, 777, 1000, 1741, 758, 782, 2741, 1476, 8482, 1518, 1212, 775, 6, 1, 2196, 778, 4223, 2778, 640, 3, 192, 585, 4216, 8667, 2512, 3421, 302, 100, 1983, 988, 4012, 1580, 1500, 1720, 778, 302, 200, 1108, 3700, 120, 678, 2, 200, 1476, 200, 778, 602, 8480, 2554, 3116, 400, 478, 156, 3666, 5000, 1034, 600, 3300, 797, 2, 84, 2706, 43, 900, 3023, 261, 1, 33, 4010, 1645, 267, 1545, 100, 855, 472, 2728, 745, 5000, 4045, 955, 680, 3000, 345, 855, 100, 3945, 555, 1000, 3045, 939, 2356, 1689, 500, 3600, 159, 400, 1400, 2245, 800, 55, 4045, 200, 333, 4740, 901, 55, 273, 2, 2, 4706, 172, 1128, 3699, 100, 60, 6131, 100, 2900, 2000, 4962, 200, 3904, 100, 1056, 3844, 1000, 4200, 856, 2592, 100, 1056, 8344, 1156, 10000, 5000, 3844, 1156, 600, 1700, 3544, 100, 900, 2844, 1020, 36, 109, 696, 4304, 696, 100, 3400, 1500, 1700, 3200, 13, 539, 200, 231, 482, 1918, 7167, 400, 1514, 3086, 5026, 1488, 3086, 26, 400, 1412, 726, 1184, 425, 5990, 426, 1483, 26, 4890, 3174, 5326, 2584, 1890, 1400, 84, 139, 2428, 1826, 356, 62, 200, 2228, 1300, 83, 663, 1482, 1, 663, 700, 1783, 1808, 213, 450, 4336, 263, 100, 1951, 414, 250, 32, 50, 30, 4306, 250, 29, 1, 700, 3507, 663, 1311, 3689, 663, 10, 1, 305, 3763, 730, 502, 3200, 6298, 3770, 300, 900, 3770, 2, 1202, 3768, 61, 100, 1041, 3700, 159, 1141, 9059, 4533, 1208, 1300, 2368, 1232, 1460, 2235, 69, 100, 1100, 7568, 1444, 2324, 604, 3858, 1142, 3768, 1101, 42, 136, 2668, 1142, 376, 4485, 2721, 1145, 900, 934, 1822, 1, 100, 9899, 76, 200, 1951, 166, 200, 1814, 5093, 73, 1957, 567, 3800, 724, 2, 200, 9436, 3253, 1673, 71, 1, 4832, 165, 2, 300, 4532, 3, 2, 9104, 4804, 193, 3, 4800, 4832, 165, 5000, 4832, 168, 88, 100, 9897, 990, 100, 1230, 6, 100, 3912, 100, 1096, 2946, 200, 1300, 3492, 1, 100, 4900, 988, 200, 2693, 88, 200, 1911, 200, 787, 5001, 987, 1, 237, 900, 87, 4013, 389, 3623, 986, 1, 200, 1519, 988, 500, 3510, 87, 1, 237, 2629, 1768, 3332, 986, 2, 28, 2, 1438, 2574, 4999, 2, 514, 2400, 4293, 7, 5000, 4886, 14, 4596, 4, 13, 1762, 2798, 2, 400, 4497, 3, 600, 2814, 1486, 1300, 3597, 3, 1300, 3597, 3, 500, 2699, 1700, 41, 100, 4859, 1370, 200, 1423, 40, 1300, 3660, 10, 696, 4304, 2287, 1410, 91, 700, 2495, 1410, 718, 300, 2325, 4973, 27, 3, 703, 3882, 367, 4, 139, 3743, 4800, 1100, 18, 1118, 3200, 682, 4900, 1118, 3882, 715, 3, 4742, 9140, 4918, 1200, 3382, 1117, 1, 4365, 603, 3882, 1018, 1800, 2082, 1000, 18, 214, 3473, 1523, 4, 7928, 1677, 256, 2155, 1114, 4, 7600, 1996, 4, 2004, 1982, 1014, 1, 500, 8382, 3883, 1114, 3, 100, 3982, 914, 1796, 5077, 3118, 4993, 1807, 2969, 1, 1900, 3090, 2097, 3, 1795, 3414, 86, 212, 3616, 803, 581, 8319, 4922, 78, 381, 1941, 1379, 1099, 2511, 6, 1381, 300, 2248, 6, 300, 6084, 175, 300, 4693, 1384, 300, 1034, 200, 1191, 8608, 1391, 3608, 1, 700, 491, 3609, 400, 2000, 1209, 91, 200, 1973, 100, 1291, 122, 4000, 3609, 1391, 1700, 1609, 36, 100, 900, 1337, 1391, 2000, 1609, 1100, 91, 3609, 7800, 2200, 2762, 33, 300, 1058, 1600, 1809, 32, 1259, 74, 3449, 30, 109, 1252, 674, 3165, 661, 700, 4198, 1174, 3826, 2739, 1784, 3609, 1391, 1174, 570, 1176, 15, 874, 1564, 1547, 5001, 3609, 1391, 1000, 2509, 1391, 2909, 1888, 3, 1000, 1074, 2109, 3, 3574, 1415, 3609, 1388, 3, 1000, 1003, 1506, 10000, 9912, 4624, 2035, 1378, 10, 200, 5974, 3808, 3, 1174, 2435, 10, 1177, 86, 2623, 1177, 1443, 80, 2, 1, 1000, 3748, 80, 1174, 200, 3613, 200, 900, 6520, 1764, 856, 2380, 900, 677, 5843, 51, 100, 2520, 80, 300, 982, 600, 1730, 50, 1100, 6420, 2375, 2720, 2231, 1080, 1200, 1389, 1031, 531, 2089, 2327, 6, 231, 2389, 4440, 636, 2294, 652, 6, 5, 1200, 3300, 2596, 53, 500, 2096, 1551, 53, 5000, 2351, 53, 78, 1496, 2401, 3, 1751, 812, 1592, 5100, 4696, 104, 4900, 4881, 119, 1049, 6847, 1804, 1651, 2045, 4, 1000, 1213, 438, 1, 4996, 4, 3690, 1310, 3686, 200, 4800, 1310, 1400, 2086, 4, 3692, 1308, 1643, 1590, 924, 443, 1, 1641, 5493, 1710, 841, 690, 608, 1643, 1490, 6866, 3654, 1349, 1090, 559, 1307, 8, 2200, 1484, 2, 100, 2337, 4, 1862, 1, 2633, 1800, 67, 1865, 2, 180, 1333, 1502, 365, 1100, 1892, 142, 1065, 4935, 67, 3033, 1865, 499, 1041, 500, 1365, 1, 100, 1371, 1167, 200, 1692, 5000, 1906, 2, 2700, 733, 1165, 1183, 682, 2, 1100, 1933, 1865, 200, 2100, 1616, 3135, 1798, 69, 700, 7369, 1867, 2, 100, 3033, 1, 1, 75, 195, 6700, 3005, 1990, 3006, 880, 600, 4223, 4005, 176, 4629, 191, 978, 3827, 192, 2, 4906, 93, 4652, 7, 613, 1952, 7, 341, 6670, 3100, 2960, 3, 300, 41, 9459, 4997, 344, 2673, 100, 241, 52, 4407, 341, 67, 4383, 9, 2966, 3602, 1057, 98, 5000, 3745, 239, 43, 1330, 5009, 541, 3833, 341, 2798, 1861, 200, 38, 19, 9385, 648, 3982, 241, 100, 4900, 573, 5, 112, 2679, 6878, 472, 400, 4202, 5009, 17, 500, 4094, 1542, 3305, 168, 4295, 389, 6, 2600, 1546, 54, 3766, 172, 5000, 100, 1700, 1975, 2, 1062, 5138, 1077, 100, 1544, 6233, 3867, 261, 5000, 828, 3093, 59, 100, 681, 300, 4672, 3126, 828, 100, 1547, 1061, 100, 523, 100, 4272, 628, 700, 4100, 51, 2015, 200, 2314, 200, 1900, 2900, 2400, 2400, 51, 3400, 100, 4704, 5000, 4197, 803, 4949, 4797, 203, 3788, 5412, 22, 3310, 312, 78, 9257, 412, 4588, 100, 1100, 2620, 77, 845, 2898, 4021, 980, 76, 1000, 2720, 1180, 100, 1185, 3614, 151, 1234, 7658, 2078, 2822, 75, 882, 217, 4783, 1382, 100, 1017, 5, 400, 976, 200, 3418, 5000, 98, 900, 2620, 82, 4, 4671, 204, 1148, 292, 1348, 400, 952, 800, 2548, 1352, 3148, 1352, 1401, 100, 1252, 326, 510, 4490, 5000, 2200, 993, 1575, 1232, 384, 4616, 2094, 300, 2406, 1700, 494, 80, 742, 300, 4700, 607, 4393, 21, 3369, 300, 4696, 5000, 200, 1334, 1169, 200, 1695, 100, 1700, 3200, 2100, 2881, 5000, 11, 1789, 3200, 1500, 3200, 29, 2400, 743, 257, 1500, 2100, 292, 3200, 400, 276, 1200, 372, 1351, 2972, 2028, 83, 5080, 3120, 48, 80, 3120, 206, 1200, 1920, 310, 80, 1000, 2120, 1400, 380, 3120, 1780, 3, 3117, 1680, 100, 3020, 1600, 80, 746, 1880, 3120, 129, 80, 49, 4951, 200, 2871, 1880, 100, 4851, 49, 3951, 5049, 2265, 280, 49, 4723, 300, 2106, 2317, 3671, 1052, 277, 1000, 1865, 1657, 200, 6877, 3141, 400, 1500, 2822, 49, 1, 10, 1686, 7752, 562, 1930, 200, 1970, 277, 5000, 485, 2367, 1, 484, 82, 300, 3834, 1082, 261, 3073, 3834, 866, 1061, 1472, 485, 36, 1209, 2200, 73, 9920, 4679, 2907, 485, 1282, 2315, 485, 300, 82, 3588, 485, 294, 3833, 485, 269, 4700, 982, 3909, 382, 643, 196, 725, 14, 450, 2986, 13, 283, 3587, 1, 1197, 1458, 1, 209, 620, 1, 182, 100, 300, 27, 4923, 4450, 427, 2355, 100, 327, 1100, 8890, 4573, 1184, 1410, 5000, 1100, 1494, 1979, 427, 2375, 219, 5000, 1842, 2558, 1419, 2000, 1194, 2106, 2500, 480, 4912, 390, 1716, 701, 1516, 1990, 4295, 791, 4, 2800, 1090, 791, 6401, 3210, 389, 4201, 795, 4, 4, 600, 3601, 4914, 90, 613, 3848, 4, 613, 29, 1, 231, 9386, 4997, 616, 2359, 4, 613, 6680, 2606, 728, 1316, 2814, 1469, 1, 200, 413, 687, 713, 4286, 2306, 100, 1880, 384, 2406, 32, 681, 613, 2406, 1800, 81, 168, 2406, 1981, 1511, 1, 1980, 6444, 915, 2200, 785, 500, 1474, 2985, 44, 100, 2847, 2015, 38, 2947, 742, 38, 4962, 1787, 2931, 9, 137, 900, 3921, 8985, 2288, 3203, 38, 200, 994, 6400, 653, 980, 1740, 13, 235, 100, 3884, 1016, 119, 3, 5978, 556, 544, 3124, 39, 945, 2548, 1022, 200, 2990, 230, 700, 51, 8915, 1385, 3615, 100, 700, 1389, 983, 100, 1214, 599, 300, 4700, 300, 1000, 2021, 1579, 7, 3314, 1479, 100, 571, 1300, 1150, 1579, 308, 600, 5000, 671, 908, 524, 66, 626, 908, 2908, 2092, 908, 600, 2721, 671, 608, 1, 4091, 100, 1900, 2092, 12, 400, 3680, 7, 4993, 2, 908, 400, 2340, 908, 300, 2444, 908, 100, 2797, 900, 8, 285, 2992, 508, 4087, 100, 1300, 3180, 139, 461, 1713, 100, 4900, 2134, 1166, 2, 370, 474, 2854, 5000, 299, 100, 4899, 5894, 1634, 1172, 1400, 272, 102, 1592, 1600, 72, 736, 2292, 1489, 1301, 400, 2928, 4, 200, 836, 1760, 5000, 1040, 692, 571, 900, 3328, 906, 766, 4299, 2071, 2164, 3, 700, 224, 1400, 700, 3524, 5000, 704, 2911, 2504, 1412, 1084, 700, 3511, 785, 1, 500, 4496, 2940, 764, 696, 9292, 1896, 2336, 270, 426, 636, 4304, 696, 3532, 600, 96, 25, 3278, 300, 396, 3974, 200, 1398, 100, 596, 81, 1026, 3278, 696, 4204, 696, 131, 26, 978, 2996, 1026, 978, 2996, 926, 977, 7851, 2300, 696, 1026, 7301, 2646, 425, 695, 101, 250, 5824, 2473, 1703, 2543, 396, 50, 1153, 158, 2537, 411, 300, 2337, 1600, 53, 358, 1853, 158, 4641, 100, 2526, 363, 1152, 1, 358, 2311, 2689, 1653, 100, 899, 1627, 267, 92, 2722, 2111, 3589, 411, 1600}
	seriesOpts = []charts.SeriesOpts{charts.WithTreeOpts(opts.TreeChart{Label: &opts.Label{Show: true}})}
)

func main() {
	store := mock.NewMockBlockchainStore(gomock.NewController(test.GoLogger{}))
	store.EXPECT().TxExists(gomock.Any()).Return(false, FP).AnyTimes()
	store.EXPECT().GetLastBlock().Return(&commonpb.Block{Header: &commonpb.BlockHeader{BlockHeight: 0}}, nil).AnyTimes()
	var conf = getTxFilterConfig()
	filter, err := txfilter.Factory().NewTxFilter(conf, Logger{}, store)
	if err != nil {
		fmt.Println("new txfilter, ERROR: ", err)
		return
	}
	heightsArray := make([]uint64, 0, heights)
	txNumberCosts := make([]opts.LineData, 0, heights)
	genLastsCosts := make([]opts.LineData, 0, heights)
	exiLastsCosts := make([]opts.LineData, 0, heights)
	addLastsCosts := make([]opts.LineData, 0, heights)
	currentFPCount := make([]opts.LineData, 0, heights)

	for height := uint64(1); height < heights+1; height++ {
		txNumber, genLasts, exiLasts, addLasts, currentFPCount0 := batch(filter, height, txNumberPerHeight)
		heightsArray = append(heightsArray, height)
		txNumberCosts = append(txNumberCosts, opts.LineData{Value: txNumber})
		genLastsCosts = append(genLastsCosts, opts.LineData{Value: genLasts.Milliseconds()})
		exiLastsCosts = append(exiLastsCosts, opts.LineData{Value: exiLasts.Milliseconds()})
		addLastsCosts = append(addLastsCosts, opts.LineData{Value: addLasts.Milliseconds()})
		currentFPCount = append(currentFPCount, opts.LineData{Value: currentFPCount0})
	}
	Report("Sharding bird's nest pressure test full befor tx number",
		"full befor tx number", heightsArray,
		Series{Name: "tx number", Data: txNumberCosts},
	)
	Report("Sharding bird's nest pressure test full befor gen time",
		"full befor gen time", heightsArray,
		Series{Name: "gen time", Data: genLastsCosts},
	)
	Report("Sharding bird's nest pressure test full befor tx exists time",
		"full befor tx exists time", heightsArray,
		Series{Name: "tx exists time", Data: exiLastsCosts, Options: seriesOpts},
	)
	Report("Sharding bird's nest pressure test full befor add tx time",
		"full befor add tx time", heightsArray,
		Series{Name: "add tx time", Data: addLastsCosts, Options: seriesOpts},
	)
	Report("Sharding bird's nest pressure test full befor fp count",
		"full befor fp count", heightsArray,
		Series{Name: "fp count", Data: currentFPCount, Options: seriesOpts},
	)
	heightsArray = make([]uint64, 0, len(TXNumbers))
	txNumberCosts = make([]opts.LineData, 0, heights)
	genLastsCosts = make([]opts.LineData, 0, heights)
	exiLastsCosts = make([]opts.LineData, 0, heights)
	addLastsCosts = make([]opts.LineData, 0, heights)
	currentFPCount = make([]opts.LineData, 0, heights)

	// 交易过滤器满后，添加指定数量交易
	height := heights
	for i := 0; i < len(TXNumbers); i++ {
		height++
		txNumber, genLasts, exiLasts, addLasts, currentFPCount0 := batch(filter, height, TXNumbers[i])
		heightsArray = append(heightsArray, height)
		txNumberCosts = append(txNumberCosts, opts.LineData{Value: txNumber})
		genLastsCosts = append(genLastsCosts, opts.LineData{Value: genLasts.Milliseconds()})
		exiLastsCosts = append(exiLastsCosts, opts.LineData{Value: exiLasts.Milliseconds()})
		addLastsCosts = append(addLastsCosts, opts.LineData{Value: addLasts.Milliseconds()})
		currentFPCount = append(currentFPCount, opts.LineData{Value: currentFPCount0})

	}

	Report("Sharding bird's nest pressure test full after tx number",
		"full after tx number", heightsArray,
		Series{Name: "tx number", Data: txNumberCosts},
	)
	Report("Sharding bird's nest pressure test full after gen time",
		"full after gen time", heightsArray,
		Series{Name: "gen time", Data: genLastsCosts},
	)
	Report("Sharding bird's nest pressure test full after tx exists time",
		"full after tx exists time", heightsArray,
		Series{Name: "tx exists time", Data: exiLastsCosts, Options: seriesOpts},
	)
	Report("Sharding bird's nest pressure test full after add tx time",
		"full after add tx time", heightsArray,
		Series{Name: "add tx time", Data: addLastsCosts, Options: seriesOpts},
	)
	Report("Sharding bird's nest pressure test full after fp count",
		"full after fp count", heightsArray,
		Series{Name: "fp count", Data: currentFPCount, Options: seriesOpts},
	)
}

func Report(title, subtitle string, xAxis interface{}, series ...Series) {
	bar := charts.NewLine()
	// set some global options like Title/Legend/ToolTip or anything else
	bar.SetGlobalOptions(
		charts.WithTitleOpts(opts.Title{
			Title:    title,
			Subtitle: subtitle,
		}),
		charts.WithLegendOpts(opts.Legend{Width: "9000"}),
	)
	// Put data into instance
	//bar.SetXAxis([]string{"Mon", "Tue", "Wed", "Thu", "Fri", "Sat", "Sun"}).
	//	AddSeries("Category A", generateBarItems()).
	//	AddSeries("Category B", generateBarItems())
	axis := bar.SetXAxis(xAxis)
	for i := range series {
		axis.AddSeries(series[i].Name, series[i].Data, series[i].Options...)
	}
	title = strings.ToLower(title)
	title = strings.Replace(title, " ", "_", -1)
	// Where the magic happens
	f, _ := os.Create(title + ".html")
	_ = bar.Render(f)

}

type Series struct {
	Name    string
	Data    []opts.LineData
	Options []charts.SeriesOpts
}

func batch(filter protocol.TxFilter, height uint64, txNumber int) (int, time.Duration, time.Duration, time.Duration, uint32) {
	var (
		currentFPCount uint32
		txs            []string
	)

	// 1. 批量生成交易ID
	gen := time.Now()
	for j := 0; j < txNumber; j++ {
		txs = append(txs, utils.GetTimestampTxId())
	}
	genLasts := time.Since(gen)

	// 2. 在交易过滤器中查重
	exi := time.Now()
	for j := 0; j < len(txs); j++ {
		exists, _, err := filter.IsExists(txs[j])
		if err != nil {
			if err.Error() == "false positive, false positive" {
				currentFPCount++
			} else {
				fmt.Println("[ERROR] is exists, error: ", err)
			}
		}
		if exists {
			fmt.Println("[WARN]: tx", txs[j], "exists")
		}
	}
	exiLasts := time.Since(exi)

	// 3. 添加到交易过滤器
	add := time.Now()
	err := filter.AddsAndSetHeight(txs, height)
	if err != nil {
		fmt.Println("[ERROR] adds and set height, ERROR: ", err)
	}
	addLasts := time.Since(add)
	fmt.Println(fmt.Sprintf("[INFO] [%v] txs: %v, gen: %v, exi: %v, add: %v, fp: %v", height, txNumber, genLasts, exiLasts, addLasts, currentFPCount))
	return txNumber, genLasts, exiLasts, addLasts, currentFPCount

}

func getTxFilterConfig() *filtercommon.TxFilterConfig {
	return &filtercommon.TxFilterConfig{
		Type:      filtercommon.TxFilterTypeShardingBirdsNest,
		BirdsNest: nil,
		ShardingBirdsNest: &sbn.ShardingBirdsNestConfig{
			Length:  5,
			Timeout: 3,
			ChainId: "chain1",
			Birdsnest: &bn.BirdsNestConfig{
				ChainId: "chain1",
				Length:  10,
				Rules: &bn.RulesConfig{
					AbsoluteExpireTime: 30000,
				},
				Cuckoo: &bn.CuckooConfig{
					KeyType:       bn.KeyType_KTTimestampKey,
					TagsPerBucket: 2,
					BitsPerItem:   11,
					MaxNumKeys:    2_000_000,
					TableType:     0,
				},
				Snapshot: &bn.SnapshotSerializerConfig{
					Type:        bn.SerializeIntervalType_Height,
					BlockHeight: &bn.BlockHeightSerializeIntervalConfig{Interval: 10},
					Path:        path,
				},
			},
			Snapshot: &bn.SnapshotSerializerConfig{
				Type:        bn.SerializeIntervalType_Height,
				BlockHeight: &bn.BlockHeightSerializeIntervalConfig{Interval: 10},
				Path:        path,
			},
		},
	}

}

func getLogger() {

}

type Logger struct {
}

func (l Logger) Debug(args ...interface{}) {

}

func (l Logger) Debugf(format string, args ...interface{}) {
}

func (l Logger) Debugw(msg string, keysAndValues ...interface{}) {
}

// Error error log print
// @param args
func (l Logger) Error(args ...interface{}) {
	fmt.Println(fmt.Sprintf("ERROR: %v\n%s", args, debug.Stack()))
}

// Errorf  error log print
// @param format
// @param args
func (l Logger) Errorf(format string, args ...interface{}) {
}

// Errorw  error log print
// @param msg
// @param keysAndValues
func (l Logger) Errorw(msg string, keysAndValues ...interface{}) {
}

// Fatal log.Fatal
// @param args
func (l Logger) Fatal(args ...interface{}) {
}

// Fatalf log.Fatalf
// @param format
// @param args
func (l Logger) Fatalf(format string, args ...interface{}) {
}

// Fatalw log.Fatalf
// @param msg
// @param keysAndValues
func (l Logger) Fatalw(msg string, keysAndValues ...interface{}) {
}

// Info info log print
// @param args
func (l Logger) Info(args ...interface{}) {
	fmt.Println("INFO: %v", args)
}

// Infof info log print
// @param format
// @param args
func (l Logger) Infof(format string, args ...interface{}) {
	fmt.Println(fmt.Sprintf("INFO: "+format, args...))
}

// Infow info log print
// @param msg
// @param keysAndValues
func (l Logger) Infow(msg string, keysAndValues ...interface{}) {
}

// Panic log.Panic
// @param args
func (l Logger) Panic(args ...interface{}) {
	fmt.Println(args...)
}

// Panicf log.Panicf
// @param format
// @param args
func (l Logger) Panicf(format string, args ...interface{}) {
	fmt.Println(fmt.Sprintf(format, args...))
}

// Panicw log.Panicf
// @param msg
// @param keysAndValues
func (l Logger) Panicw(msg string, keysAndValues ...interface{}) {
}

// Warn warn log print
// @param args
func (l Logger) Warn(args ...interface{}) {
	fmt.Println("WARN: %v\n%s", args, debug.Stack())
}

// Warnf warn log print
// @param format
// @param args
func (l Logger) Warnf(format string, args ...interface{}) {
	str := fmt.Sprintf(format, args...)
	fmt.Println("WARN: "+str+"\n%s", debug.Stack())
}

// Warnw warn log print
// @param msg
// @param keysAndValues
func (l Logger) Warnw(msg string, keysAndValues ...interface{}) {
}

func (l Logger) DebugDynamic(getStr func() string) {

}

func (l Logger) InfoDynamic(getStr func() string) {
	fmt.Println("INFO:", getStr())
}
